/**
 * 
 */
package com.ejie.ab04b.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.bind.DatatypeConverter;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

import com.ejie.ab04b.constantes.Constantes;
import com.ejie.ab04b.constantes.ConstantesNum;
import com.ejie.ab04b.constantes.ConstantesPlateaTramitacion;
import com.ejie.ab04b.exception.AB04BParseException;
import com.ejie.ab04b.exception.ParametroKey;

/**
 * @author GFI-NORTE
 * 
 */
public class Utilities {

	private static Utilities instance;

	public static final String REGEX_EMAIL = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@"
			+ "[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})$";

	/**
	 * Devuelve la instancia de tipo Utilities.
	 * 
	 *  Devuelve la instancia de tipo Utilities
	 *
	 * @return single instance of Utilities
	 */
	public static final Utilities getInstance() {
		if (Utilities.instance == null) {
			Utilities.instance = new Utilities();
		}
		return Utilities.instance;
	}

	/**
	 * Formatea un Date para ser utilizado dependiendo del idioma.
	 * 
	 *  entrada
	 *            Date
	 * 
	 *  String
	 *
	 * @param entrada the entrada
	 * @return the string
	 */
	public String formatearDateIdioma(Date entrada) {

		String resultado = "";
		Locale locale = LocaleContextHolder.getLocale();
		String mascara = locale.getLanguage().equals(
				Constantes.LOCALE_EU.getLanguage()) ? Constantes.EU_DATE_MASK
				: Constantes.ES_DATE_MASK;
		if (entrada != null) {
			SimpleDateFormat formato = new SimpleDateFormat(mascara, locale);
			resultado = formato.format(entrada);
		}
		return resultado;
	}

	/**
	 * Devuelve la maskara de fechas para ser utilizado dependiendo del idioma.
	 * 
	 *  String
	 *
	 * @return the date mask
	 */
	public String getDateMask() {
		Locale locale = LocaleContextHolder.getLocale();
		return locale.getLanguage().equals(Constantes.LOCALE_EU.getLanguage()) ? Constantes.EU_DATE_MASK
				: Constantes.ES_DATE_MASK;
	}

	/**
	 * Obtiene un String con el stackTrace de un Throwable.
	 * 
	 *  aThrowable
	 *            Throwable
	 *  String
	 *
	 * @param aThrowable the a throwable
	 * @return the stack trace
	 */
	public String getStackTrace(Throwable aThrowable) {

		return ExceptionUtils.getStackTrace(aThrowable);
	}

	/**
	 * Consigue el mensaje "code" del messageSource indicado, en el idioma
	 * actual
	 * 
	 * *Es posible que si se cambian los literales a BBDD, haga falta cambiar*.
	 * 
	 *  messageSource
	 *            ReloadableResourceBundleMessageSource
	 *  code
	 *            String
	 *  String
	 *
	 * @param messageSource the message source
	 * @param code the code
	 * @return the literal message
	 */
	public static String getLiteralMessage(
			ReloadableResourceBundleMessageSource messageSource, String code) {
		return Utilities.getInstance().getLiteralMessageWithParams(
				messageSource, code, null);
	}

	/**
	 * Consigue el mensaje "code" del messageSource indicado, en el idioma
	 * actual, utilizando los parametros indicados
	 * 
	 * *Es posible que si se cambian los literales a BBDD, haga falta cambiar*.
	 * 
	 *  messageSource
	 *            ReloadableResourceBundleMessageSource
	 *  code
	 *            String
	 *  params
	 *            Object[]
	 *  String
	 *
	 * @param messageSource the message source
	 * @param code the code
	 * @param params the params
	 * @return the literal message with params
	 */
	public String getLiteralMessageWithParams(
			ReloadableResourceBundleMessageSource messageSource, String code,
			Object[] params) {
		Locale locale = LocaleContextHolder.getLocale();
		return messageSource.getMessage(code, params, locale);
	}

	/**
	 * Metodo que parsea los parametros a objects.
	 * 
	 *  messageSource
	 *            ReloadableResourceBundleMessageSource
	 *  listaParametroKey
	 *            List<ParametroKey>
	 *  Object[]
	 *
	 * @param messageSource the message source
	 * @param listaParametroKey the lista parametro key
	 * @return the object[]
	 */
	public Object[] parseParametroKeyToObject(
			ReloadableResourceBundleMessageSource messageSource,
			List<ParametroKey> listaParametroKey) {
		Object[] objetos = null;
		if (listaParametroKey != null && !listaParametroKey.isEmpty()) {
			objetos = new Object[listaParametroKey.size()];
			Iterator<ParametroKey> it = listaParametroKey.iterator();
			int i = 0;
			ParametroKey parametroKey = null;
			Locale locale = LocaleContextHolder.getLocale();
			while (it.hasNext()) {
				parametroKey = it.next();
				objetos[i] = parametroKey.isKey() ? messageSource
						.getParentMessageSource().getMessage(
								parametroKey.getValorParametro(), null, null,
								locale) : parametroKey.getValorParametro();
				i++;
			}
		}
		return objetos;
	}

	/**
	 * Devuelve el procedureId del procedimiento de Apertura de Centro.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerProcedureIdApertura() {
		return PropertiesUtil.getProperty(PropertiesUtil.PROCEDURE_ID_APERTURA);
	}

	/**
	 * Devuelve el procedureId del procedimiento de Comunicación de OS2.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerProcedureIdOs2() {
		return PropertiesUtil.getProperty(PropertiesUtil.PROCEDURE_ID_OS2);
	}

	/**
	 * Devuelve el procedureId del procedimiento de Comunicación de OS3.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerProcedureIdOs3() {
		return PropertiesUtil.getProperty(PropertiesUtil.PROCEDURE_ID_OS3);
	}

	/**
	 * Devuelve el daprocedureId del procedimiento de Apertura de Centro.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerDaProcedureIdApertura() {
		return PropertiesUtil
				.getProperty(PropertiesUtil.DA_PROCEDURE_ID_APERTURA);
	}

	/**
	 * Devuelve el daprocedureId del procedimiento de Comunicación de OS2.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerDaProcedureIdOs2() {
		return PropertiesUtil.getProperty(PropertiesUtil.DA_PROCEDURE_ID_OS2);
	}

	/**
	 * Devuelve el daprocedureId del procedimiento de Comunicación de OS3.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerDaProcedureIdOs3() {
		return PropertiesUtil.getProperty(PropertiesUtil.DA_PROCEDURE_ID_OS3);
	}

	/**
	 * Obtener entity id.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerEntityId() {
		return PropertiesUtil.getProperty(PropertiesUtil.ENTITY_ID);
	}

	/**
	 * Obtener entity name.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerEntityName(String locale) {
		StringBuilder key = new StringBuilder(PropertiesUtil.ENTITY_NAME)
				.append(Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Obtener organism id.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerOrganismId() {
		return PropertiesUtil.getProperty(PropertiesUtil.ORGANISM_ID);
	}

	/**
	 * Obtener organism name.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerOrganismName(String locale) {
		StringBuilder key = new StringBuilder(PropertiesUtil.ORGANISM_NAME)
				.append(Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Obtener department id.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerDepartmentId() {
		return PropertiesUtil.getProperty(PropertiesUtil.DEPARTMENT_ID);
	}

	/**
	 * Obtener department name.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerDepartmentName(String locale) {
		StringBuilder key = new StringBuilder(PropertiesUtil.DEPARTMENT_NAME)
				.append(Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Obtener managingunit id.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerManagingunitId() {
		return PropertiesUtil.getProperty(PropertiesUtil.MANAGINGUNIT_ID);
	}

	/**
	 * Obtener managingunit name.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerManagingunitName(String locale) {
		StringBuilder key = new StringBuilder(PropertiesUtil.MANAGINGUNIT_NAME)
				.append(Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Obtener organism id osalan.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerOrganismIdOsalan() {
		return PropertiesUtil.getProperty(PropertiesUtil.ORGANISM_OSALAN_ID);
	}

	/**
	 * Obtener organism name osalan.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerOrganismNameOsalan(String locale) {
		StringBuilder key = new StringBuilder(
				PropertiesUtil.ORGANISM_OSALAN_NAME).append(
				Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Obtener department id osalan.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerDepartmentIdOsalan() {
		return PropertiesUtil.getProperty(PropertiesUtil.DEPARTMENT_OSALAN_ID);
	}

	/**
	 * Obtener department name osalan.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerDepartmentNameOsalan(String locale) {
		StringBuilder key = new StringBuilder(
				PropertiesUtil.DEPARTMENT_OSALAN_NAME).append(
				Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Obtener managingunit id osalan.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	public String obtenerManagingunitIdOsalan() {
		return PropertiesUtil
				.getProperty(PropertiesUtil.MANAGINGUNIT_OSALAN_ID);
	}

	/**
	 * Obtener managingunit name osalan.
	 * 
	 *  locale
	 *            String
	 *  String
	 *
	 * @param locale the locale
	 * @return the string
	 */
	public String obtenerManagingunitNameOsalan(String locale) {
		StringBuilder key = new StringBuilder(
				PropertiesUtil.MANAGINGUNIT_OSALAN_NAME).append(
				Constantes.SEPARADOR_PUNTO).append(locale);
		return PropertiesUtil.getProperty(key.toString());
	}

	/**
	 * Comprueba si en cierta cadena aparece el patron '%'.
	 * 
	 *  cadena
	 *            String donde queremos saber si contiene ciertos caracteres
	 *  boolean
	 *
	 * @param cadena the cadena
	 * @return true, if successful
	 */
	public boolean containsPatternLike(final Object cadena) {
		return this.containsPattern((String) cadena, Constantes.PATRON_LIKE);
	}

	/**
	 * Comprueba si en cierta cadena aparece un patron.
	 * 
	 *  cadena
	 *            String donde queremos saber si contiene ciertos caracteres
	 *  patron
	 *            String que queremos buscar
	 *  boolean
	 *
	 * @param cadena the cadena
	 * @param patron the patron
	 * @return true, if successful
	 */
	public boolean containsPattern(final String cadena, final String patron) {
		boolean contiene = false;
		if (cadena != null && patron != null && !("").equalsIgnoreCase(cadena)
				&& !("").equalsIgnoreCase(patron)) {
			contiene = cadena.contains(patron);
		}
		return contiene;
	}

	/**
	 * Convierte un contenido hexadecimal en String.
	 * 
	 *  content
	 *            String
	 *  el contenido del documento como String
	 *
	 * @param content the content
	 * @return the string
	 * @throws AB04BParseException             excepción el la codificacion
	 */
	public String parseHexAsString(String content) throws AB04BParseException {
		if (content != null) {
			try {
				return new String(DatatypeConverter.parseHexBinary(content),
						"UTF-8");
			} catch (UnsupportedEncodingException e) {
				throw new AB04BParseException(e);
			}
		}
		return null;
	}

	/**
	 * Devuelve true si el texto es nulo o vacío.
	 * 
	 *  text
	 *            String
	 *  boolean
	 *
	 * @param text the text
	 * @return true, if is empty
	 */
	public boolean isEmpty(String text) {
		return (text == null || text.isEmpty());
	}

	/**
	 * Devuelve la extensión de un nombre de fichero buscando a partir del
	 * último carácter punto "."
	 * 
	 *  nombreFichero
	 *            String
	 *  String
	 *
	 * @param nombreFichero the nombre fichero
	 * @return the string
	 */
	public String obtenerExtensionFichero(String nombreFichero) {
		if (!this.isEmpty(nombreFichero)) {
			int index = nombreFichero.lastIndexOf(Constantes.SEPARADOR_PUNTO);
			if (index != -1) {
				return nombreFichero.substring(index + 1);
			}
		}
		return "";
	}

	/**
	 * Función que elimina acentos y caracteres especiales de una cadena de
	 * texto.
	 * 
	 *  input
	 *            String
	 *  cadena de texto limpia de acentos y caracteres especiales.
	 *
	 * @param input the input
	 * @return the string
	 */
	public String quitarCaracteresEspecialesEspacios(String input) {

		String output = Normalizer.normalize(input, Normalizer.Form.NFD)
				.replaceAll("[^\\p{ASCII}]", "");

		// Cadena de caracteres que directamente desaparecerán
		String desaparecen = "ºª!\"·$%&/=|@#~€¬`ç´-^Ç¨_:;<> ";

		output = output.replaceAll("\\\\", "");
		output = output.replaceAll("\\)", "");
		output = output.replaceAll("\\(", "");
		output = output.replaceAll("\\?", "");
		output = output.replaceAll("\\¿", "");
		output = output.replaceAll("\\+", "");
		output = output.replaceAll("\\*", "");
		output = output.replaceAll("\\[", "");
		output = output.replaceAll("\\]", "");
		output = output.replaceAll("\\{", "");
		output = output.replaceAll("\\}", "");
		output = output.replaceAll("\\,", "");
		output = output.replaceAll("\\.", "");
		for (int i = 0; i < desaparecen.length(); i++) {
			// Reemplazamos los caracteres especiales.

			output = output.replaceAll(String.valueOf(desaparecen.charAt(i)),
					"");
		}
		return output;
	}

	/**
	 * Devuelve un string con la fecha del sistema en formato date.
	 * 
	 *  String String con la fecha en formato AAAAMMDD
	 *
	 * @return the date
	 * @throws ParseException             excep.
	 */
	public Date fncObtenerFechaHoy() throws ParseException {
		Date now = new Date();

		SimpleDateFormat sdfSource = new SimpleDateFormat(
				Constantes.CTE_MASCARA_FECHA_DIA_MES_ANO);
		String s1 = sdfSource.format(now);
		// parse the string into Date object

		return sdfSource.parse(s1);
	}

	/**
	 * Convierte un string en fecha.
	 * 
	 *  str
	 *            el string
	 *  la fecha
	 *
	 * @param str the str
	 * @return the date
	 * @throws ParseException             excepcion de parseo
	 */
	public Date stringToDate(String str) throws ParseException {
		if (str == null) {
			return null;
		}
		String mask = "dd/MM/yyyy";
		if (str.split("/")[0].length() == Integer.parseInt("4")) {
			mask = "yyyy/MM/dd";
		}
		SimpleDateFormat formatter = new SimpleDateFormat(mask);
		return formatter.parse(str);
	}

	/**
	 * Convierte un string en fecha.
	 * 
	 *  str
	 *            el string
	 *  la fecha
	 *
	 * @param str the str
	 * @return the date
	 * @throws ParseException             excepcion de parseo
	 */
	public Date stringToDatePlatea(String str) throws ParseException {
		if (str == null) {
			return null;
		}
		String mask = Constantes.PLATEA_TIMESTAMP_FORMAT;
		if (str.split("/")[0].length() == Integer.parseInt("4")) {
			mask = "yyyy/MM/dd";
		}
		SimpleDateFormat formatter = new SimpleDateFormat(mask);
		return formatter.parse(str);
	}

	/**
	 * Convierte una fecha en string.
	 * 
	 *  date
	 *            Date
	 *  Sting
	 *
	 * @param date the date
	 * @return the string
	 */
	public String dateToStringPPS(Date date) {

		String resultado = "";
		Locale locale = LocaleContextHolder.getLocale();
		String mascara = locale.getLanguage().equals(Constantes.LOCALE_EU) ? ConstantesPlateaTramitacion.PPS_REGISTRY_TIMESTAMP_FORMAT
				: ConstantesPlateaTramitacion.PPS_REGISTRY_TIMESTAMP_FORMAT;
		if (date != null) {
			SimpleDateFormat formato = new SimpleDateFormat(mascara, locale);
			resultado = formato.format(date);
		}
		return resultado;

	}

	/**
	 * Metodo que obtiene una cadena con los parámetros recibidos.
	 * 
	 *  cadena
	 *            String
	 *  String
	 *
	 * @param cadena the cadena
	 * @return the string
	 */
	public static String obtenerCadena(String... cadena) {
		StringBuilder stb = new StringBuilder();
		for (int i = 0; i < cadena.length; i++) {
			stb.append(cadena[i]);
		}
		return stb.toString();
	}

	/**
	 * Devuelve true en caso de que la lista sea: <li><b>null</b></li> <li>
	 * <b>length == 0</b></li>.<br>
	 * 
	 *  lista
	 *            List<?>
	 *  Boolean
	 *
	 * @param lista the lista
	 * @return the boolean
	 */
	public static Boolean isEmptyList(List<?> lista) {
		return lista == null || lista.isEmpty();
	}

	/**
	 * Metodo que rellena con 0.
	 * 
	 *  cadena
	 *            String
	 *  numTot
	 *            int
	 *  String
	 *
	 * @param cadena the cadena
	 * @param numTot the num tot
	 * @return the string
	 */
	public static String rellenarCeros(String cadena, int numTot) {
		StringBuilder cadenaAux = new StringBuilder(cadena);
		if (cadena == null) {
			cadenaAux.append("");
		}
		int longStr = cadenaAux.length();
		int numBlancos = numTot - longStr;
		for (int j = 0; j < numBlancos; j++) {
			cadenaAux.append("0").append(cadenaAux);
		}
		return cadenaAux.toString();
	}

	/**
	 * Conformar nombre completo.
	 * 
	 *  nombre
	 *            String
	 *  apellido1
	 *            String
	 *  apellido2
	 *            String
	 *  String
	 *
	 * @param nombre the nombre
	 * @param apellido1 the apellido 1
	 * @param apellido2 the apellido 2
	 * @return the string
	 */
	public String conformarNombreCompleto(String nombre, String apellido1,
			String apellido2) {

		StringBuilder sb = new StringBuilder();
		sb.append(nombre);
		if (!this.isEmpty(apellido1)) {
			sb.append(Constantes.ESPACIO);
			sb.append(apellido1);
			if (!this.isEmpty(apellido2)) {
				sb.append(Constantes.ESPACIO);
				sb.append(apellido2);
			}
		}

		return sb.toString();
	}

	/**
	 * Str territorio.
	 * 
	 *  terape
	 *            String
	 *  String
	 *
	 * @param terape the terape
	 * @return the string
	 */
	public String strTerritorio(String terape) {
		String territorio = "";

		if (terape.equals(Constantes.TH_ALAVA)) {
			territorio = Constantes.DESC_TH_ALAVA;
		} else if (terape.equals(Constantes.TH_GIPUZKOA)) {
			territorio = Constantes.DESC_TH_GIPUZKOA;
		} else if (terape.equals(Constantes.TH_BIZKAIA)) {
			territorio = Constantes.DESC_TH_BIZKAIA;
		}

		return territorio;
	}

	/**
	 * Str month.
	 * 
	 *  mes
	 *            int
	 *  String
	 *
	 * @param mes the mes
	 * @return the string
	 */
	public String strMonth(int mes) {
		String month = "";
		Locale locale = LocaleContextHolder.getLocale();
		if (locale.getLanguage().equals(Constantes.LOCALE_EU)) {
			switch (mes) {
			case 1:
				month = Constantes.ENERO_EU;
				break;
			case ConstantesNum.NUM_2:
				month = Constantes.FEBRERO_EU;
				break;
			case ConstantesNum.NUM_3:
				month = Constantes.MARZO_EU;
				break;
			case ConstantesNum.NUM_4:
				month = Constantes.ABRIL_EU;
				break;
			case ConstantesNum.NUM_5:
				month = Constantes.MAYO_EU;
				break;
			case ConstantesNum.NUM_6:
				month = Constantes.JUNIO_EU;
				break;
			case ConstantesNum.NUM_7:
				month = Constantes.JULIO_EU;
				break;
			case ConstantesNum.NUM_8:
				month = Constantes.AGOSTO_EU;
				break;
			case ConstantesNum.NUM_9:
				month = Constantes.SEPTIEMBRE_EU;
				break;
			case ConstantesNum.NUM_10:
				month = Constantes.OCTUBRE_EU;
				break;
			case ConstantesNum.NUM_11:
				month = Constantes.NOVIEMBRE_EU;
				break;
			case ConstantesNum.NUM_12:
				month = Constantes.DICIEMBRE_EU;
				break;
			default:
				break;
			}
		} else {
			switch (mes) {
			case 1:
				month = Constantes.ENERO;
				break;
			case ConstantesNum.NUM_2:
				month = Constantes.FEBRERO;
				break;
			case ConstantesNum.NUM_3:
				month = Constantes.MARZO;
				break;
			case ConstantesNum.NUM_4:
				month = Constantes.ABRIL;
				break;
			case ConstantesNum.NUM_5:
				month = Constantes.MAYO;
				break;
			case ConstantesNum.NUM_6:
				month = Constantes.JUNIO;
				break;
			case ConstantesNum.NUM_7:
				month = Constantes.JULIO;
				break;
			case ConstantesNum.NUM_8:
				month = Constantes.AGOSTO;
				break;
			case ConstantesNum.NUM_9:
				month = Constantes.SEPTIEMBRE;
				break;
			case ConstantesNum.NUM_10:
				month = Constantes.OCTUBRE;
				break;
			case ConstantesNum.NUM_11:
				month = Constantes.NOVIEMBRE;
				break;
			case ConstantesNum.NUM_12:
				month = Constantes.DICIEMBRE;
				break;
			default:
				break;
			}
		}
		return month;
	}

	/**
	 * Read file.
	 * 
	 *  fileName
	 *            String
	 *  String
	 *
	 * @param fileName the file name
	 * @return the string
	 * @throws IOException             Exception
	 */
	public static String readFile(String fileName) throws IOException {
		BufferedReader br = new BufferedReader(new FileReader(fileName));
		try {
			StringBuilder sb = new StringBuilder();
			String line = br.readLine();

			while (line != null) {
				sb.append(line);
				sb.append("\n");
				line = br.readLine();
			}
			return sb.toString();
		} finally {
			br.close();
		}
	}

	/**
	 * Validar email.
	 * 
	 *  emailStr
	 *            String
	 *  boolean
	 *
	 * @param emailStr the email str
	 * @return true, if successful
	 */
	public boolean compruebaEmail(String emailStr) {

		Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile(
				"^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,6}$",
				Pattern.CASE_INSENSITIVE);

		Matcher matcher = VALID_EMAIL_ADDRESS_REGEX.matcher(emailStr);
		return matcher.find();
	}
	/**
	 * Chequea que el modo de Acceso no es MANTENIMIENTO, en cuyo caso lanza
	 * excepción
	 * 
	 * @param cif
	 *            String
	 * @return boolean
	 */
	public boolean esCooperativa(String cif) {
		if (cif.startsWith("F")) {
			return true;
		}
		return false;
	}
}
